// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DeferExpressionPluginInfo.C
// ****************************************************************************

#include <DeferExpressionPluginInfo.h>
#include <DeferExpressionAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(DeferExpression,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(DeferExpression,General)

// ****************************************************************************
//  Method: DeferExpressionGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DeferExpressionGeneralPluginInfo::GetName() const
{
    return "DeferExpression";
}

// ****************************************************************************
//  Method: DeferExpressionGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DeferExpressionGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: DeferExpressionGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DeferExpressionGeneralPluginInfo::GetID() const
{
    return "DeferExpression_1.0";
}
// ****************************************************************************
//  Method: DeferExpressionGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
DeferExpressionGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: DeferExpressionGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DeferExpressionGeneralPluginInfo::GetCategoryName() const
{
    return "Analysis";
}
