// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DeferExpressionCommonPluginInfo.C
// ****************************************************************************

#include <DeferExpressionPluginInfo.h>
#include <DeferExpressionAttributes.h>

// ****************************************************************************
//  Method: DeferExpressionCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
DeferExpressionCommonPluginInfo::AllocAttributes()
{
    return new DeferExpressionAttributes;
}

// ****************************************************************************
//  Method: DeferExpressionCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a DeferExpression attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
DeferExpressionCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((DeferExpressionAttributes *) to) = *((DeferExpressionAttributes *) from);
}
