// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISDECIMATEWINDOW_H
#define QVISDECIMATEWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class DecimateAttributes;
class QLabel;
class QLineEdit;

// ****************************************************************************
// Class: QvisDecimateWindow
//
// Purpose:
//    Defines QvisDecimateWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisDecimateWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisDecimateWindow(const int type,
                         DecimateAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisDecimateWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void targetProcessText();
  private:
    QLineEdit *target;
    QLabel *targetLabel;

    DecimateAttributes *atts;
};



#endif
