// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisDecimateWindow.h"

#include <DecimateAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisDecimateWindow::QvisDecimateWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisDecimateWindow::QvisDecimateWindow(const int type,
                         DecimateAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisDecimateWindow::~QvisDecimateWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisDecimateWindow::~QvisDecimateWindow()
{
}


// ****************************************************************************
// Method: QvisDecimateWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisDecimateWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    targetLabel = new QLabel(tr("Target Reduction "), central);
    mainLayout->addWidget(targetLabel,0,0);
    target = new QLineEdit(central);
    connect(target, SIGNAL(returnPressed()),
            this, SLOT(targetProcessText()));
    mainLayout->addWidget(target, 0,1);

}


// ****************************************************************************
// Method: QvisDecimateWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisDecimateWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case DecimateAttributes::ID_target:
            target->setText(DoubleToQString(atts->GetTarget()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisDecimateWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisDecimateWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do target
    if(which_widget == DecimateAttributes::ID_target || doAll)
    {
        double val;
        if(LineEditGetDouble(target, val))
        {
            if (val < 0. || val > 1.)
            {
                QString msg = tr("The reduction target field is only valid between 0"
                    " 1.  The number specified is the proportion of number of "
                    "polygonal cells in the outputted dataset \"over\" the "
                    "number of polygonal cells in the original dataset.  "
                    "Resetting to the last good value of %1.").
                    arg(atts->GetTarget());
                Message(msg);
                atts->SetTarget(atts->GetTarget());
            }
            else
                atts->SetTarget(val);
        }
        else
        {
            ResettingError(tr("Target Reduction "),
                DoubleToQString(atts->GetTarget()));
            atts->SetTarget(atts->GetTarget());
        }
    }

}


//
// Qt Slot functions
//


void
QvisDecimateWindow::targetProcessText()
{
    GetCurrentValues(DecimateAttributes::ID_target);
    Apply();
}


