// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyDecimateAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyDecimateAttributes
//
// Purpose:
//   This class contains attributes for the decimate operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a DecimateAttributes.
//
struct DecimateAttributesObject
{
    PyObject_HEAD
    DecimateAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewDecimateAttributes(int);

std::string
PyDecimateAttributes_ToString(const DecimateAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%starget = %g\n", prefix, atts->GetTarget());
    str += tmpStr;
    return str;
}

static PyObject *
DecimateAttributes_Notify(PyObject *self, PyObject *args)
{
    DecimateAttributesObject *obj = (DecimateAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DecimateAttributes_SetTarget(PyObject *self, PyObject *args)
{
    DecimateAttributesObject *obj = (DecimateAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the target in the object.
    obj->data->SetTarget(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DecimateAttributes_GetTarget(PyObject *self, PyObject *args)
{
    DecimateAttributesObject *obj = (DecimateAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTarget());
    return retval;
}



PyMethodDef PyDecimateAttributes_methods[DECIMATEATTRIBUTES_NMETH] = {
    {"Notify", DecimateAttributes_Notify, METH_VARARGS},
    {"SetTarget", DecimateAttributes_SetTarget, METH_VARARGS},
    {"GetTarget", DecimateAttributes_GetTarget, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
DecimateAttributes_dealloc(PyObject *v)
{
   DecimateAttributesObject *obj = (DecimateAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
DecimateAttributes_compare(PyObject *v, PyObject *w)
{
    DecimateAttributes *a = ((DecimateAttributesObject *)v)->data;
    DecimateAttributes *b = ((DecimateAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyDecimateAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "target") == 0)
        return DecimateAttributes_GetTarget(self, NULL);

    return Py_FindMethod(PyDecimateAttributes_methods, self, name);
}

int
PyDecimateAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "target") == 0)
        obj = DecimateAttributes_SetTarget(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
DecimateAttributes_print(PyObject *v, FILE *fp, int flags)
{
    DecimateAttributesObject *obj = (DecimateAttributesObject *)v;
    fprintf(fp, "%s", PyDecimateAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
DecimateAttributes_str(PyObject *v)
{
    DecimateAttributesObject *obj = (DecimateAttributesObject *)v;
    return PyString_FromString(PyDecimateAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *DecimateAttributes_Purpose = "This class contains attributes for the decimate operator.";
#else
static char *DecimateAttributes_Purpose = "This class contains attributes for the decimate operator.";
#endif

//
// The type description structure
//
static PyTypeObject DecimateAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "DecimateAttributes",                    // tp_name
    sizeof(DecimateAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)DecimateAttributes_dealloc,  // tp_dealloc
    (printfunc)DecimateAttributes_print,     // tp_print
    (getattrfunc)PyDecimateAttributes_getattr, // tp_getattr
    (setattrfunc)PyDecimateAttributes_setattr, // tp_setattr
    (cmpfunc)DecimateAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)DecimateAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    DecimateAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static DecimateAttributes *defaultAtts = 0;
static DecimateAttributes *currentAtts = 0;

static PyObject *
NewDecimateAttributes(int useCurrent)
{
    DecimateAttributesObject *newObject;
    newObject = PyObject_NEW(DecimateAttributesObject, &DecimateAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new DecimateAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new DecimateAttributes(*defaultAtts);
    else
        newObject->data = new DecimateAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapDecimateAttributes(const DecimateAttributes *attr)
{
    DecimateAttributesObject *newObject;
    newObject = PyObject_NEW(DecimateAttributesObject, &DecimateAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (DecimateAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
DecimateAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewDecimateAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef DecimateAttributesMethods[] = {
    {"DecimateAttributes", DecimateAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *DecimateAttributesObserver = 0;

std::string
PyDecimateAttributes_GetLogString()
{
    std::string s("DecimateAtts = DecimateAttributes()\n");
    if(currentAtts != 0)
        s += PyDecimateAttributes_ToString(currentAtts, "DecimateAtts.");
    return s;
}

static void
PyDecimateAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("DecimateAtts = DecimateAttributes()\n");
        s += PyDecimateAttributes_ToString(currentAtts, "DecimateAtts.");
        cb(s);
    }
}

void
PyDecimateAttributes_StartUp(DecimateAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyDecimateAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(DecimateAttributesObserver == 0)
    {
        DecimateAttributesObserver = new ObserverToCallback(subj,
            PyDecimateAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyDecimateAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete DecimateAttributesObserver;
    DecimateAttributesObserver = 0;
}

PyMethodDef *
PyDecimateAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return DecimateAttributesMethods;
}

bool
PyDecimateAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &DecimateAttributesType);
}

DecimateAttributes *
PyDecimateAttributes_FromPyObject(PyObject *obj)
{
    DecimateAttributesObject *obj2 = (DecimateAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyDecimateAttributes_New()
{
    return NewDecimateAttributes(0);
}

PyObject *
PyDecimateAttributes_Wrap(const DecimateAttributes *attr)
{
    return WrapDecimateAttributes(attr);
}

void
PyDecimateAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    DecimateAttributesObject *obj2 = (DecimateAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyDecimateAttributes_SetDefaults(const DecimateAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new DecimateAttributes(*atts);
}

