// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <DecimateAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: DecimateAttributes::DecimateAttributes
//
// Purpose:
//   Init utility for the DecimateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void DecimateAttributes::Init()
{
    target = 0.1;

    DecimateAttributes::SelectAll();
}

// ****************************************************************************
// Method: DecimateAttributes::DecimateAttributes
//
// Purpose:
//   Copy utility for the DecimateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void DecimateAttributes::Copy(const DecimateAttributes &obj)
{
    target = obj.target;

    DecimateAttributes::SelectAll();
}

// Type map format string
const char *DecimateAttributes::TypeMapFormatString = DECIMATEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t DecimateAttributes::TmfsStruct = {DECIMATEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: DecimateAttributes::DecimateAttributes
//
// Purpose:
//   Default constructor for the DecimateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DecimateAttributes::DecimateAttributes() :
    AttributeSubject(DecimateAttributes::TypeMapFormatString)
{
    DecimateAttributes::Init();
}

// ****************************************************************************
// Method: DecimateAttributes::DecimateAttributes
//
// Purpose:
//   Constructor for the derived classes of DecimateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DecimateAttributes::DecimateAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    DecimateAttributes::Init();
}

// ****************************************************************************
// Method: DecimateAttributes::DecimateAttributes
//
// Purpose:
//   Copy constructor for the DecimateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DecimateAttributes::DecimateAttributes(const DecimateAttributes &obj) :
    AttributeSubject(DecimateAttributes::TypeMapFormatString)
{
    DecimateAttributes::Copy(obj);
}

// ****************************************************************************
// Method: DecimateAttributes::DecimateAttributes
//
// Purpose:
//   Copy constructor for derived classes of the DecimateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DecimateAttributes::DecimateAttributes(const DecimateAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    DecimateAttributes::Copy(obj);
}

// ****************************************************************************
// Method: DecimateAttributes::~DecimateAttributes
//
// Purpose:
//   Destructor for the DecimateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DecimateAttributes::~DecimateAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: DecimateAttributes::operator =
//
// Purpose:
//   Assignment operator for the DecimateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DecimateAttributes&
DecimateAttributes::operator = (const DecimateAttributes &obj)
{
    if (this == &obj) return *this;

    DecimateAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: DecimateAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the DecimateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DecimateAttributes::operator == (const DecimateAttributes &obj) const
{
    // Create the return value
    return ((target == obj.target));
}

// ****************************************************************************
// Method: DecimateAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the DecimateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DecimateAttributes::operator != (const DecimateAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: DecimateAttributes::TypeName
//
// Purpose:
//   Type name method for the DecimateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
DecimateAttributes::TypeName() const
{
    return "DecimateAttributes";
}

// ****************************************************************************
// Method: DecimateAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the DecimateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DecimateAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const DecimateAttributes *tmp = (const DecimateAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: DecimateAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the DecimateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
DecimateAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new DecimateAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: DecimateAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the DecimateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
DecimateAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new DecimateAttributes(*this);
    else
        retval = new DecimateAttributes;

    return retval;
}

// ****************************************************************************
// Method: DecimateAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DecimateAttributes::SelectAll()
{
    Select(ID_target, (void *)&target);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DecimateAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DecimateAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    DecimateAttributes defaultObject;
    bool addToParent = false;
    // Create a node for DecimateAttributes.
    DataNode *node = new DataNode("DecimateAttributes");

    if(completeSave || !FieldsEqual(ID_target, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("target", target));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: DecimateAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DecimateAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("DecimateAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("target")) != 0)
        SetTarget(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
DecimateAttributes::SetTarget(double target_)
{
    target = target_;
    Select(ID_target, (void *)&target);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

double
DecimateAttributes::GetTarget() const
{
    return target;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DecimateAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
DecimateAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_target: return "target";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DecimateAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
DecimateAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_target: return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: DecimateAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
DecimateAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_target: return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DecimateAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DecimateAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const DecimateAttributes &obj = *((const DecimateAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_target:
        {  // new scope
        retval = (target == obj.target);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

