// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DataBinningViewerEnginePluginInfo.C
// ****************************************************************************

#include <DataBinningPluginInfo.h>
#include <DataBinningAttributes.h>

//
// Storage for static data elements.
//
DataBinningAttributes *DataBinningViewerEnginePluginInfo::clientAtts = NULL;
DataBinningAttributes *DataBinningViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  DataBinningViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
DataBinningViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (DataBinningViewerEnginePluginInfo::clientAtts == NULL)
    {
        DataBinningViewerEnginePluginInfo::clientAtts  = new DataBinningAttributes;
        DataBinningViewerEnginePluginInfo::defaultAtts = new DataBinningAttributes;
    }
}

// ****************************************************************************
//  Method: DataBinningViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
DataBinningViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: DataBinningViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
DataBinningViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: DataBinningViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
DataBinningViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(DataBinningAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: DataBinningViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
DataBinningViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(DataBinningAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: DataBinningViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
DataBinningViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(DataBinningAttributes*)atts = *defaultAtts;
    else
        *(DataBinningAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: DataBinningViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to update the attributes from the defaults. False
//                to update from the current attributes.
//
//  Programmer: Brad Whitlock
//  Creation:   Wed Jun 27 10:10:44 PDT 2012
//
//  Modifications:
//    Brad Whitlock, Wed Jun 27 10:13:24 PDT 2012
//    I transplanted this code from the old version of
//    DataBinningAttributes::CopyAttributes since we should just set the
//    operator dimensions when we create the operator attributes.
//
// ****************************************************************************

#include <avtPlotMetaData.h>

void
DataBinningViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts,
    const avtPlotMetaData &plot)
{
    DataBinningAttributes *binning = (DataBinningAttributes *)atts;

    // Set the number of dimensions based on the variable name.
    const char *varname = plot.GetVariableName().c_str();
    if (strstr(varname, "operators/DataBinning/1D") != NULL)
        binning->SetNumDimensions(DataBinningAttributes::One);
    else if (strstr(varname, "operators/DataBinning/2D") != NULL)
        binning->SetNumDimensions(DataBinningAttributes::Two);
    else if (strstr(varname, "operators/DataBinning/3D") != NULL)
        binning->SetNumDimensions(DataBinningAttributes::Three);
}

// ****************************************************************************
//  Method: DataBinningViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DataBinningViewerEnginePluginInfo::GetMenuName() const
{
    return "DataBinning";
}

