// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: DataBinningPluginInfo.C
// ****************************************************************************

#include <DataBinningPluginInfo.h>
#include <DataBinningAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(DataBinning,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(DataBinning,General)

// ****************************************************************************
//  Method: DataBinningGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DataBinningGeneralPluginInfo::GetName() const
{
    return "DataBinning";
}

// ****************************************************************************
//  Method: DataBinningGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DataBinningGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: DataBinningGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DataBinningGeneralPluginInfo::GetID() const
{
    return "DataBinning_1.0";
}
// ****************************************************************************
//  Method: DataBinningGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
DataBinningGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: DataBinningGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
DataBinningGeneralPluginInfo::GetCategoryName() const
{
    return "Analysis";
}
