// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISCYLINDERWINDOW_H
#define QVISCYLINDERWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class CylinderAttributes;
class QLabel;
class QCheckBox;
class QLineEdit;

// ****************************************************************************
// Class: QvisCylinderWindow
//
// Purpose:
//    Defines QvisCylinderWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisCylinderWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisCylinderWindow(const int type,
                         CylinderAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisCylinderWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void point1ProcessText();
    void point2ProcessText();
    void radiusProcessText();
    void inverseChanged(bool val);
  private:
    QLineEdit *point1;
    QLineEdit *point2;
    QLineEdit *radius;
    QCheckBox *inverse;
    QLabel *point1Label;
    QLabel *point2Label;
    QLabel *radiusLabel;

    CylinderAttributes *atts;
};



#endif
