// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CylinderPluginInfo.h
// ****************************************************************************

#ifndef CYLINDER_PLUGIN_INFO_H
#define CYLINDER_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class CylinderAttributes;

// ****************************************************************************
//  Class: CylinderPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Cylinder operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class CylinderGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class CylinderCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual CylinderGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class CylinderGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual CylinderCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class CylinderViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual CylinderCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static CylinderAttributes *defaultAtts;
    static CylinderAttributes *clientAtts;
};

class CylinderViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual CylinderViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class CylinderEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual CylinderViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class CylinderScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual CylinderCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
