// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyCreateBondsAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyCreateBondsAttributes
//
// Purpose:
//   Attributes for the CreateBondsOperator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a CreateBondsAttributes.
//
struct CreateBondsAttributesObject
{
    PyObject_HEAD
    CreateBondsAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewCreateBondsAttributes(int);

std::string
PyCreateBondsAttributes_ToString(const CreateBondsAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%selementVariable = \"%s\"\n", prefix, atts->GetElementVariable().c_str());
    str += tmpStr;
    {   const intVector &atomicNumber1 = atts->GetAtomicNumber1();
        snprintf(tmpStr, 1000, "%satomicNumber1 = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < atomicNumber1.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%d", atomicNumber1[i]);
            str += tmpStr;
            if(i < atomicNumber1.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &atomicNumber2 = atts->GetAtomicNumber2();
        snprintf(tmpStr, 1000, "%satomicNumber2 = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < atomicNumber2.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%d", atomicNumber2[i]);
            str += tmpStr;
            if(i < atomicNumber2.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &minDist = atts->GetMinDist();
        snprintf(tmpStr, 1000, "%sminDist = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < minDist.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%g", minDist[i]);
            str += tmpStr;
            if(i < minDist.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &maxDist = atts->GetMaxDist();
        snprintf(tmpStr, 1000, "%smaxDist = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < maxDist.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%g", maxDist[i]);
            str += tmpStr;
            if(i < maxDist.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%smaxBondsClamp = %d\n", prefix, atts->GetMaxBondsClamp());
    str += tmpStr;
    if(atts->GetAddPeriodicBonds())
        snprintf(tmpStr, 1000, "%saddPeriodicBonds = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%saddPeriodicBonds = 0\n", prefix);
    str += tmpStr;
    if(atts->GetUseUnitCellVectors())
        snprintf(tmpStr, 1000, "%suseUnitCellVectors = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%suseUnitCellVectors = 0\n", prefix);
    str += tmpStr;
    if(atts->GetPeriodicInX())
        snprintf(tmpStr, 1000, "%speriodicInX = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%speriodicInX = 0\n", prefix);
    str += tmpStr;
    if(atts->GetPeriodicInY())
        snprintf(tmpStr, 1000, "%speriodicInY = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%speriodicInY = 0\n", prefix);
    str += tmpStr;
    if(atts->GetPeriodicInZ())
        snprintf(tmpStr, 1000, "%speriodicInZ = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%speriodicInZ = 0\n", prefix);
    str += tmpStr;
    {   const double *xVector = atts->GetXVector();
        snprintf(tmpStr, 1000, "%sxVector = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", xVector[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *yVector = atts->GetYVector();
        snprintf(tmpStr, 1000, "%syVector = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", yVector[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *zVector = atts->GetZVector();
        snprintf(tmpStr, 1000, "%szVector = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", zVector[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
CreateBondsAttributes_Notify(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CreateBondsAttributes_SetElementVariable(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the elementVariable in the object.
    obj->data->SetElementVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CreateBondsAttributes_GetElementVariable(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetElementVariable().c_str());
    return retval;
}

/*static*/ PyObject *
CreateBondsAttributes_SetAtomicNumber1(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;

    intVector  &vec = obj->data->GetAtomicNumber1();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the atomicNumber1 in the object as modified.
    obj->data->SelectAtomicNumber1();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CreateBondsAttributes_GetAtomicNumber1(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the atomicNumber1.
    const intVector &atomicNumber1 = obj->data->GetAtomicNumber1();
    PyObject *retval = PyTuple_New(atomicNumber1.size());
    for(size_t i = 0; i < atomicNumber1.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(atomicNumber1[i])));
    return retval;
}

/*static*/ PyObject *
CreateBondsAttributes_SetAtomicNumber2(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;

    intVector  &vec = obj->data->GetAtomicNumber2();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the atomicNumber2 in the object as modified.
    obj->data->SelectAtomicNumber2();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CreateBondsAttributes_GetAtomicNumber2(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the atomicNumber2.
    const intVector &atomicNumber2 = obj->data->GetAtomicNumber2();
    PyObject *retval = PyTuple_New(atomicNumber2.size());
    for(size_t i = 0; i < atomicNumber2.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(atomicNumber2[i])));
    return retval;
}

/*static*/ PyObject *
CreateBondsAttributes_SetMinDist(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;

    doubleVector  &vec = obj->data->GetMinDist();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the minDist in the object as modified.
    obj->data->SelectMinDist();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CreateBondsAttributes_GetMinDist(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the minDist.
    const doubleVector &minDist = obj->data->GetMinDist();
    PyObject *retval = PyTuple_New(minDist.size());
    for(size_t i = 0; i < minDist.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(minDist[i]));
    return retval;
}

/*static*/ PyObject *
CreateBondsAttributes_SetMaxDist(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;

    doubleVector  &vec = obj->data->GetMaxDist();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the maxDist in the object as modified.
    obj->data->SelectMaxDist();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CreateBondsAttributes_GetMaxDist(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the maxDist.
    const doubleVector &maxDist = obj->data->GetMaxDist();
    PyObject *retval = PyTuple_New(maxDist.size());
    for(size_t i = 0; i < maxDist.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(maxDist[i]));
    return retval;
}

/*static*/ PyObject *
CreateBondsAttributes_SetMaxBondsClamp(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxBondsClamp in the object.
    obj->data->SetMaxBondsClamp((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CreateBondsAttributes_GetMaxBondsClamp(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxBondsClamp()));
    return retval;
}

/*static*/ PyObject *
CreateBondsAttributes_SetAddPeriodicBonds(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the addPeriodicBonds in the object.
    obj->data->SetAddPeriodicBonds(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CreateBondsAttributes_GetAddPeriodicBonds(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAddPeriodicBonds()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CreateBondsAttributes_SetUseUnitCellVectors(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useUnitCellVectors in the object.
    obj->data->SetUseUnitCellVectors(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CreateBondsAttributes_GetUseUnitCellVectors(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseUnitCellVectors()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CreateBondsAttributes_SetPeriodicInX(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the periodicInX in the object.
    obj->data->SetPeriodicInX(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CreateBondsAttributes_GetPeriodicInX(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPeriodicInX()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CreateBondsAttributes_SetPeriodicInY(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the periodicInY in the object.
    obj->data->SetPeriodicInY(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CreateBondsAttributes_GetPeriodicInY(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPeriodicInY()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CreateBondsAttributes_SetPeriodicInZ(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the periodicInZ in the object.
    obj->data->SetPeriodicInZ(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CreateBondsAttributes_GetPeriodicInZ(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPeriodicInZ()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CreateBondsAttributes_SetXVector(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;

    double *dvals = obj->data->GetXVector();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the xVector in the object as modified.
    obj->data->SelectXVector();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CreateBondsAttributes_GetXVector(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the xVector.
    PyObject *retval = PyTuple_New(3);
    const double *xVector = obj->data->GetXVector();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(xVector[i]));
    return retval;
}

/*static*/ PyObject *
CreateBondsAttributes_SetYVector(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;

    double *dvals = obj->data->GetYVector();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the yVector in the object as modified.
    obj->data->SelectYVector();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CreateBondsAttributes_GetYVector(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the yVector.
    PyObject *retval = PyTuple_New(3);
    const double *yVector = obj->data->GetYVector();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(yVector[i]));
    return retval;
}

/*static*/ PyObject *
CreateBondsAttributes_SetZVector(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;

    double *dvals = obj->data->GetZVector();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the zVector in the object as modified.
    obj->data->SelectZVector();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CreateBondsAttributes_GetZVector(PyObject *self, PyObject *args)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the zVector.
    PyObject *retval = PyTuple_New(3);
    const double *zVector = obj->data->GetZVector();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(zVector[i]));
    return retval;
}



PyMethodDef PyCreateBondsAttributes_methods[CREATEBONDSATTRIBUTES_NMETH] = {
    {"Notify", CreateBondsAttributes_Notify, METH_VARARGS},
    {"SetElementVariable", CreateBondsAttributes_SetElementVariable, METH_VARARGS},
    {"GetElementVariable", CreateBondsAttributes_GetElementVariable, METH_VARARGS},
    {"SetAtomicNumber1", CreateBondsAttributes_SetAtomicNumber1, METH_VARARGS},
    {"GetAtomicNumber1", CreateBondsAttributes_GetAtomicNumber1, METH_VARARGS},
    {"SetAtomicNumber2", CreateBondsAttributes_SetAtomicNumber2, METH_VARARGS},
    {"GetAtomicNumber2", CreateBondsAttributes_GetAtomicNumber2, METH_VARARGS},
    {"SetMinDist", CreateBondsAttributes_SetMinDist, METH_VARARGS},
    {"GetMinDist", CreateBondsAttributes_GetMinDist, METH_VARARGS},
    {"SetMaxDist", CreateBondsAttributes_SetMaxDist, METH_VARARGS},
    {"GetMaxDist", CreateBondsAttributes_GetMaxDist, METH_VARARGS},
    {"SetMaxBondsClamp", CreateBondsAttributes_SetMaxBondsClamp, METH_VARARGS},
    {"GetMaxBondsClamp", CreateBondsAttributes_GetMaxBondsClamp, METH_VARARGS},
    {"SetAddPeriodicBonds", CreateBondsAttributes_SetAddPeriodicBonds, METH_VARARGS},
    {"GetAddPeriodicBonds", CreateBondsAttributes_GetAddPeriodicBonds, METH_VARARGS},
    {"SetUseUnitCellVectors", CreateBondsAttributes_SetUseUnitCellVectors, METH_VARARGS},
    {"GetUseUnitCellVectors", CreateBondsAttributes_GetUseUnitCellVectors, METH_VARARGS},
    {"SetPeriodicInX", CreateBondsAttributes_SetPeriodicInX, METH_VARARGS},
    {"GetPeriodicInX", CreateBondsAttributes_GetPeriodicInX, METH_VARARGS},
    {"SetPeriodicInY", CreateBondsAttributes_SetPeriodicInY, METH_VARARGS},
    {"GetPeriodicInY", CreateBondsAttributes_GetPeriodicInY, METH_VARARGS},
    {"SetPeriodicInZ", CreateBondsAttributes_SetPeriodicInZ, METH_VARARGS},
    {"GetPeriodicInZ", CreateBondsAttributes_GetPeriodicInZ, METH_VARARGS},
    {"SetXVector", CreateBondsAttributes_SetXVector, METH_VARARGS},
    {"GetXVector", CreateBondsAttributes_GetXVector, METH_VARARGS},
    {"SetYVector", CreateBondsAttributes_SetYVector, METH_VARARGS},
    {"GetYVector", CreateBondsAttributes_GetYVector, METH_VARARGS},
    {"SetZVector", CreateBondsAttributes_SetZVector, METH_VARARGS},
    {"GetZVector", CreateBondsAttributes_GetZVector, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
CreateBondsAttributes_dealloc(PyObject *v)
{
   CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
CreateBondsAttributes_compare(PyObject *v, PyObject *w)
{
    CreateBondsAttributes *a = ((CreateBondsAttributesObject *)v)->data;
    CreateBondsAttributes *b = ((CreateBondsAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyCreateBondsAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "elementVariable") == 0)
        return CreateBondsAttributes_GetElementVariable(self, NULL);
    if(strcmp(name, "atomicNumber1") == 0)
        return CreateBondsAttributes_GetAtomicNumber1(self, NULL);
    if(strcmp(name, "atomicNumber2") == 0)
        return CreateBondsAttributes_GetAtomicNumber2(self, NULL);
    if(strcmp(name, "minDist") == 0)
        return CreateBondsAttributes_GetMinDist(self, NULL);
    if(strcmp(name, "maxDist") == 0)
        return CreateBondsAttributes_GetMaxDist(self, NULL);
    if(strcmp(name, "maxBondsClamp") == 0)
        return CreateBondsAttributes_GetMaxBondsClamp(self, NULL);
    if(strcmp(name, "addPeriodicBonds") == 0)
        return CreateBondsAttributes_GetAddPeriodicBonds(self, NULL);
    if(strcmp(name, "useUnitCellVectors") == 0)
        return CreateBondsAttributes_GetUseUnitCellVectors(self, NULL);
    if(strcmp(name, "periodicInX") == 0)
        return CreateBondsAttributes_GetPeriodicInX(self, NULL);
    if(strcmp(name, "periodicInY") == 0)
        return CreateBondsAttributes_GetPeriodicInY(self, NULL);
    if(strcmp(name, "periodicInZ") == 0)
        return CreateBondsAttributes_GetPeriodicInZ(self, NULL);
    if(strcmp(name, "xVector") == 0)
        return CreateBondsAttributes_GetXVector(self, NULL);
    if(strcmp(name, "yVector") == 0)
        return CreateBondsAttributes_GetYVector(self, NULL);
    if(strcmp(name, "zVector") == 0)
        return CreateBondsAttributes_GetZVector(self, NULL);

    return Py_FindMethod(PyCreateBondsAttributes_methods, self, name);
}

int
PyCreateBondsAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "elementVariable") == 0)
        obj = CreateBondsAttributes_SetElementVariable(self, tuple);
    else if(strcmp(name, "atomicNumber1") == 0)
        obj = CreateBondsAttributes_SetAtomicNumber1(self, tuple);
    else if(strcmp(name, "atomicNumber2") == 0)
        obj = CreateBondsAttributes_SetAtomicNumber2(self, tuple);
    else if(strcmp(name, "minDist") == 0)
        obj = CreateBondsAttributes_SetMinDist(self, tuple);
    else if(strcmp(name, "maxDist") == 0)
        obj = CreateBondsAttributes_SetMaxDist(self, tuple);
    else if(strcmp(name, "maxBondsClamp") == 0)
        obj = CreateBondsAttributes_SetMaxBondsClamp(self, tuple);
    else if(strcmp(name, "addPeriodicBonds") == 0)
        obj = CreateBondsAttributes_SetAddPeriodicBonds(self, tuple);
    else if(strcmp(name, "useUnitCellVectors") == 0)
        obj = CreateBondsAttributes_SetUseUnitCellVectors(self, tuple);
    else if(strcmp(name, "periodicInX") == 0)
        obj = CreateBondsAttributes_SetPeriodicInX(self, tuple);
    else if(strcmp(name, "periodicInY") == 0)
        obj = CreateBondsAttributes_SetPeriodicInY(self, tuple);
    else if(strcmp(name, "periodicInZ") == 0)
        obj = CreateBondsAttributes_SetPeriodicInZ(self, tuple);
    else if(strcmp(name, "xVector") == 0)
        obj = CreateBondsAttributes_SetXVector(self, tuple);
    else if(strcmp(name, "yVector") == 0)
        obj = CreateBondsAttributes_SetYVector(self, tuple);
    else if(strcmp(name, "zVector") == 0)
        obj = CreateBondsAttributes_SetZVector(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
CreateBondsAttributes_print(PyObject *v, FILE *fp, int flags)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)v;
    fprintf(fp, "%s", PyCreateBondsAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
CreateBondsAttributes_str(PyObject *v)
{
    CreateBondsAttributesObject *obj = (CreateBondsAttributesObject *)v;
    return PyString_FromString(PyCreateBondsAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *CreateBondsAttributes_Purpose = "Attributes for the CreateBondsOperator";
#else
static char *CreateBondsAttributes_Purpose = "Attributes for the CreateBondsOperator";
#endif

//
// The type description structure
//
static PyTypeObject CreateBondsAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "CreateBondsAttributes",                    // tp_name
    sizeof(CreateBondsAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)CreateBondsAttributes_dealloc,  // tp_dealloc
    (printfunc)CreateBondsAttributes_print,     // tp_print
    (getattrfunc)PyCreateBondsAttributes_getattr, // tp_getattr
    (setattrfunc)PyCreateBondsAttributes_setattr, // tp_setattr
    (cmpfunc)CreateBondsAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)CreateBondsAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    CreateBondsAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static CreateBondsAttributes *defaultAtts = 0;
static CreateBondsAttributes *currentAtts = 0;

static PyObject *
NewCreateBondsAttributes(int useCurrent)
{
    CreateBondsAttributesObject *newObject;
    newObject = PyObject_NEW(CreateBondsAttributesObject, &CreateBondsAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new CreateBondsAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new CreateBondsAttributes(*defaultAtts);
    else
        newObject->data = new CreateBondsAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapCreateBondsAttributes(const CreateBondsAttributes *attr)
{
    CreateBondsAttributesObject *newObject;
    newObject = PyObject_NEW(CreateBondsAttributesObject, &CreateBondsAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (CreateBondsAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
CreateBondsAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewCreateBondsAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef CreateBondsAttributesMethods[] = {
    {"CreateBondsAttributes", CreateBondsAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *CreateBondsAttributesObserver = 0;

std::string
PyCreateBondsAttributes_GetLogString()
{
    std::string s("CreateBondsAtts = CreateBondsAttributes()\n");
    if(currentAtts != 0)
        s += PyCreateBondsAttributes_ToString(currentAtts, "CreateBondsAtts.");
    return s;
}

static void
PyCreateBondsAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("CreateBondsAtts = CreateBondsAttributes()\n");
        s += PyCreateBondsAttributes_ToString(currentAtts, "CreateBondsAtts.");
        cb(s);
    }
}

void
PyCreateBondsAttributes_StartUp(CreateBondsAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyCreateBondsAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(CreateBondsAttributesObserver == 0)
    {
        CreateBondsAttributesObserver = new ObserverToCallback(subj,
            PyCreateBondsAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyCreateBondsAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete CreateBondsAttributesObserver;
    CreateBondsAttributesObserver = 0;
}

PyMethodDef *
PyCreateBondsAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return CreateBondsAttributesMethods;
}

bool
PyCreateBondsAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &CreateBondsAttributesType);
}

CreateBondsAttributes *
PyCreateBondsAttributes_FromPyObject(PyObject *obj)
{
    CreateBondsAttributesObject *obj2 = (CreateBondsAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyCreateBondsAttributes_New()
{
    return NewCreateBondsAttributes(0);
}

PyObject *
PyCreateBondsAttributes_Wrap(const CreateBondsAttributes *attr)
{
    return WrapCreateBondsAttributes(attr);
}

void
PyCreateBondsAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    CreateBondsAttributesObject *obj2 = (CreateBondsAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyCreateBondsAttributes_SetDefaults(const CreateBondsAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new CreateBondsAttributes(*atts);
}

