// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  CreateBondsScriptingPluginInfo.C
// ************************************************************************* //
#include <PyCreateBondsAttributes.h>
#include <CreateBondsPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(CreateBonds,Scripting)

// ****************************************************************************
// Method: CreateBondsScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
CreateBondsScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyCreateBondsAttributes_StartUp((CreateBondsAttributes *)subj, data);
}

// ****************************************************************************
// Method: CreateBondsScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
CreateBondsScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyCreateBondsAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: CreateBondsScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is CreateBonds plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
CreateBondsScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyCreateBondsAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: CreateBondsScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
CreateBondsScriptingPluginInfo::GetLogString()
{
    std::string s(PyCreateBondsAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: CreateBondsScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
CreateBondsScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyCreateBondsAttributes_SetDefaults((const CreateBondsAttributes *)atts);
}
