// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CreateBondsPluginInfo.h
// ****************************************************************************

#ifndef CREATEBONDS_PLUGIN_INFO_H
#define CREATEBONDS_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class CreateBondsAttributes;

// ****************************************************************************
//  Class: CreateBondsPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an CreateBonds operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class CreateBondsGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class CreateBondsCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual CreateBondsGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class CreateBondsGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual CreateBondsCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class CreateBondsViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual CreateBondsCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static CreateBondsAttributes *defaultAtts;
    static CreateBondsAttributes *clientAtts;
};

class CreateBondsViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual CreateBondsViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class CreateBondsEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual CreateBondsViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class CreateBondsScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual CreateBondsCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
