// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtCracksDensityFilter.h
// ************************************************************************* //

#ifndef AVT_CracksDensity_FILTER_H
#define AVT_CracksDensity_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <CracksClipperAttributes.h>


// ****************************************************************************
//  Class: avtCracksDensityFilter
//
//  Purpose:
//      A plugin operator for CracksDensity.
//
//  Programmer: kbonnell -- generated by xml2avt
//  Creation:   Mon Apr 30 11:40:50 PDT 2007
//
//  Modifications:
//    Kathleen Biagas, Tue Aug 14 15:14:57 MST 2012
//    Add 'varname' ivar.
//
//    Eric Brugger, Wed Jul 23 11:13:24 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtCracksDensityFilter : public avtPluginDataTreeIterator
{
  public:
                         avtCracksDensityFilter();
    virtual             ~avtCracksDensityFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtCracksDensityFilter"; };
    virtual const char  *GetDescription(void)
                             { return "CracksDensity"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

    void                 SetVarName(const std::string &v)
                             { varname = v; }
  protected:
    CracksClipperAttributes atts;
    std::string           varname;
    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
};


#endif
