// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CracksClipperPluginInfo.h
// ****************************************************************************

#ifndef CRACKSCLIPPER_PLUGIN_INFO_H
#define CRACKSCLIPPER_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class CracksClipperAttributes;

// ****************************************************************************
//  Class: CracksClipperPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an CracksClipper operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class CracksClipperGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class CracksClipperCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual CracksClipperGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
    virtual ExpressionList *GetCreatedExpressions(const avtDatabaseMetaData *) const;
};

class CracksClipperGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual CracksClipperCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class CracksClipperViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual CracksClipperCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static CracksClipperAttributes *defaultAtts;
    static CracksClipperAttributes *clientAtts;
};

class CracksClipperViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual CracksClipperViewerEnginePluginInfo
{
  public:
};

class CracksClipperEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual CracksClipperViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class CracksClipperScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual CracksClipperCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
