// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CracksClipperPluginInfo.C
// ****************************************************************************

#include <CracksClipperPluginInfo.h>
#include <CracksClipperAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(CracksClipper,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(CracksClipper,General)

// ****************************************************************************
//  Method: CracksClipperGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CracksClipperGeneralPluginInfo::GetName() const
{
    return "CracksClipper";
}

// ****************************************************************************
//  Method: CracksClipperGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CracksClipperGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: CracksClipperGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CracksClipperGeneralPluginInfo::GetID() const
{
    return "CracksClipper_1.0";
}
// ****************************************************************************
//  Method: CracksClipperGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
CracksClipperGeneralPluginInfo::EnabledByDefault() const
{
    return false;
}

// ****************************************************************************
//  Method: CracksClipperGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CracksClipperGeneralPluginInfo::GetCategoryName() const
{
    return "Analysis";
}
