// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtCoordSwapFilter.h
// ************************************************************************* //

#ifndef AVT_CoordSwap_FILTER_H
#define AVT_CoordSwap_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <CoordSwapAttributes.h>


// ****************************************************************************
//  Class: avtCoordSwapFilter
//
//  Purpose:
//      A plugin operator for CoordSwap.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Wed Feb 2 16:09:10 PST 2005
//
//  Modifications:
//    Eric Brugger, Wed Jul 23 11:09:30 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtCoordSwapFilter : public avtPluginDataTreeIterator
{
  public:
                         avtCoordSwapFilter();
    virtual             ~avtCoordSwapFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtCoordSwapFilter"; };
    virtual const char  *GetDescription(void)
                             { return "CoordSwap"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

    void                 SwapExtents(const double *, double *);

  protected:
    CoordSwapAttributes   atts;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);

    void                  UpdateDataObjectInfo(void);
};


#endif
