// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CoordSwapPluginInfo.h
// ****************************************************************************

#ifndef COORDSWAP_PLUGIN_INFO_H
#define COORDSWAP_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class CoordSwapAttributes;

// ****************************************************************************
//  Class: CoordSwapPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an CoordSwap operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class CoordSwapGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class CoordSwapCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual CoordSwapGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class CoordSwapGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual CoordSwapCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class CoordSwapViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual CoordSwapCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static CoordSwapAttributes *defaultAtts;
    static CoordSwapAttributes *clientAtts;
};

class CoordSwapViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual CoordSwapViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class CoordSwapEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual CoordSwapViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class CoordSwapScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual CoordSwapCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
