// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisConnectedComponentsWindow.h"

#include <ConnectedComponentsAttributes.h>

#include <QCheckBox>
#include <QLayout>


// ****************************************************************************
// Method: QvisConnectedComponentsWindow::QvisConnectedComponentsWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisConnectedComponentsWindow::QvisConnectedComponentsWindow(const int type,
                         ConnectedComponentsAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisConnectedComponentsWindow::~QvisConnectedComponentsWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisConnectedComponentsWindow::~QvisConnectedComponentsWindow()
{
}


// ****************************************************************************
// Method: QvisConnectedComponentsWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisConnectedComponentsWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    EnableGhostNeighborsOptimization = new QCheckBox(tr("Use Ghosts Zone Neighbors for connectivity between Domains"), central);
    connect(EnableGhostNeighborsOptimization, SIGNAL(toggled(bool)),
            this, SLOT(EnableGhostNeighborsOptimizationChanged(bool)));
    mainLayout->addWidget(EnableGhostNeighborsOptimization, 0,0);

}


// ****************************************************************************
// Method: QvisConnectedComponentsWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisConnectedComponentsWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case ConnectedComponentsAttributes::ID_EnableGhostNeighborsOptimization:
            EnableGhostNeighborsOptimization->blockSignals(true);
            EnableGhostNeighborsOptimization->setChecked(atts->GetEnableGhostNeighborsOptimization());
            EnableGhostNeighborsOptimization->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisConnectedComponentsWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisConnectedComponentsWindow::GetCurrentValues(int which_widget)
{
}


//
// Qt Slot functions
//


void
QvisConnectedComponentsWindow::EnableGhostNeighborsOptimizationChanged(bool val)
{
    atts->SetEnableGhostNeighborsOptimization(val);
    SetUpdate(false);
    Apply();
}


