// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyConnectedComponentsAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyConnectedComponentsAttributes
//
// Purpose:
//   Attributes for Connected Components operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ConnectedComponentsAttributes.
//
struct ConnectedComponentsAttributesObject
{
    PyObject_HEAD
    ConnectedComponentsAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewConnectedComponentsAttributes(int);

std::string
PyConnectedComponentsAttributes_ToString(const ConnectedComponentsAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetEnableGhostNeighborsOptimization())
        snprintf(tmpStr, 1000, "%sEnableGhostNeighborsOptimization = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sEnableGhostNeighborsOptimization = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
ConnectedComponentsAttributes_Notify(PyObject *self, PyObject *args)
{
    ConnectedComponentsAttributesObject *obj = (ConnectedComponentsAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConnectedComponentsAttributes_SetEnableGhostNeighborsOptimization(PyObject *self, PyObject *args)
{
    ConnectedComponentsAttributesObject *obj = (ConnectedComponentsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the EnableGhostNeighborsOptimization in the object.
    obj->data->SetEnableGhostNeighborsOptimization(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConnectedComponentsAttributes_GetEnableGhostNeighborsOptimization(PyObject *self, PyObject *args)
{
    ConnectedComponentsAttributesObject *obj = (ConnectedComponentsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetEnableGhostNeighborsOptimization()?1L:0L);
    return retval;
}



PyMethodDef PyConnectedComponentsAttributes_methods[CONNECTEDCOMPONENTSATTRIBUTES_NMETH] = {
    {"Notify", ConnectedComponentsAttributes_Notify, METH_VARARGS},
    {"SetEnableGhostNeighborsOptimization", ConnectedComponentsAttributes_SetEnableGhostNeighborsOptimization, METH_VARARGS},
    {"GetEnableGhostNeighborsOptimization", ConnectedComponentsAttributes_GetEnableGhostNeighborsOptimization, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ConnectedComponentsAttributes_dealloc(PyObject *v)
{
   ConnectedComponentsAttributesObject *obj = (ConnectedComponentsAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ConnectedComponentsAttributes_compare(PyObject *v, PyObject *w)
{
    ConnectedComponentsAttributes *a = ((ConnectedComponentsAttributesObject *)v)->data;
    ConnectedComponentsAttributes *b = ((ConnectedComponentsAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyConnectedComponentsAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "EnableGhostNeighborsOptimization") == 0)
        return ConnectedComponentsAttributes_GetEnableGhostNeighborsOptimization(self, NULL);

    return Py_FindMethod(PyConnectedComponentsAttributes_methods, self, name);
}

int
PyConnectedComponentsAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "EnableGhostNeighborsOptimization") == 0)
        obj = ConnectedComponentsAttributes_SetEnableGhostNeighborsOptimization(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ConnectedComponentsAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ConnectedComponentsAttributesObject *obj = (ConnectedComponentsAttributesObject *)v;
    fprintf(fp, "%s", PyConnectedComponentsAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ConnectedComponentsAttributes_str(PyObject *v)
{
    ConnectedComponentsAttributesObject *obj = (ConnectedComponentsAttributesObject *)v;
    return PyString_FromString(PyConnectedComponentsAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ConnectedComponentsAttributes_Purpose = "Attributes for Connected Components operator";
#else
static char *ConnectedComponentsAttributes_Purpose = "Attributes for Connected Components operator";
#endif

//
// The type description structure
//
static PyTypeObject ConnectedComponentsAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ConnectedComponentsAttributes",                    // tp_name
    sizeof(ConnectedComponentsAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ConnectedComponentsAttributes_dealloc,  // tp_dealloc
    (printfunc)ConnectedComponentsAttributes_print,     // tp_print
    (getattrfunc)PyConnectedComponentsAttributes_getattr, // tp_getattr
    (setattrfunc)PyConnectedComponentsAttributes_setattr, // tp_setattr
    (cmpfunc)ConnectedComponentsAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ConnectedComponentsAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ConnectedComponentsAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ConnectedComponentsAttributes *defaultAtts = 0;
static ConnectedComponentsAttributes *currentAtts = 0;

static PyObject *
NewConnectedComponentsAttributes(int useCurrent)
{
    ConnectedComponentsAttributesObject *newObject;
    newObject = PyObject_NEW(ConnectedComponentsAttributesObject, &ConnectedComponentsAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ConnectedComponentsAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ConnectedComponentsAttributes(*defaultAtts);
    else
        newObject->data = new ConnectedComponentsAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapConnectedComponentsAttributes(const ConnectedComponentsAttributes *attr)
{
    ConnectedComponentsAttributesObject *newObject;
    newObject = PyObject_NEW(ConnectedComponentsAttributesObject, &ConnectedComponentsAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ConnectedComponentsAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ConnectedComponentsAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewConnectedComponentsAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ConnectedComponentsAttributesMethods[] = {
    {"ConnectedComponentsAttributes", ConnectedComponentsAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ConnectedComponentsAttributesObserver = 0;

std::string
PyConnectedComponentsAttributes_GetLogString()
{
    std::string s("ConnectedComponentsAtts = ConnectedComponentsAttributes()\n");
    if(currentAtts != 0)
        s += PyConnectedComponentsAttributes_ToString(currentAtts, "ConnectedComponentsAtts.");
    return s;
}

static void
PyConnectedComponentsAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ConnectedComponentsAtts = ConnectedComponentsAttributes()\n");
        s += PyConnectedComponentsAttributes_ToString(currentAtts, "ConnectedComponentsAtts.");
        cb(s);
    }
}

void
PyConnectedComponentsAttributes_StartUp(ConnectedComponentsAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyConnectedComponentsAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ConnectedComponentsAttributesObserver == 0)
    {
        ConnectedComponentsAttributesObserver = new ObserverToCallback(subj,
            PyConnectedComponentsAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyConnectedComponentsAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ConnectedComponentsAttributesObserver;
    ConnectedComponentsAttributesObserver = 0;
}

PyMethodDef *
PyConnectedComponentsAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ConnectedComponentsAttributesMethods;
}

bool
PyConnectedComponentsAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ConnectedComponentsAttributesType);
}

ConnectedComponentsAttributes *
PyConnectedComponentsAttributes_FromPyObject(PyObject *obj)
{
    ConnectedComponentsAttributesObject *obj2 = (ConnectedComponentsAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyConnectedComponentsAttributes_New()
{
    return NewConnectedComponentsAttributes(0);
}

PyObject *
PyConnectedComponentsAttributes_Wrap(const ConnectedComponentsAttributes *attr)
{
    return WrapConnectedComponentsAttributes(attr);
}

void
PyConnectedComponentsAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ConnectedComponentsAttributesObject *obj2 = (ConnectedComponentsAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyConnectedComponentsAttributes_SetDefaults(const ConnectedComponentsAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ConnectedComponentsAttributes(*atts);
}

