// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef CONNECTEDCOMPONENTSATTRIBUTES_H
#define CONNECTEDCOMPONENTSATTRIBUTES_H
#include <AttributeSubject.h>


// ****************************************************************************
// Class: ConnectedComponentsAttributes
//
// Purpose:
//    Attributes for Connected Components operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class ConnectedComponentsAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    ConnectedComponentsAttributes();
    ConnectedComponentsAttributes(const ConnectedComponentsAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    ConnectedComponentsAttributes(private_tmfs_t tmfs);
    ConnectedComponentsAttributes(const ConnectedComponentsAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~ConnectedComponentsAttributes();

    virtual ConnectedComponentsAttributes& operator = (const ConnectedComponentsAttributes &obj);
    virtual bool operator == (const ConnectedComponentsAttributes &obj) const;
    virtual bool operator != (const ConnectedComponentsAttributes &obj) const;
private:
    void Init();
    void Copy(const ConnectedComponentsAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetEnableGhostNeighborsOptimization(bool EnableGhostNeighborsOptimization_);

    // Property getting methods
    bool GetEnableGhostNeighborsOptimization() const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_EnableGhostNeighborsOptimization = 0,
        ID__LAST
    };

private:
    bool EnableGhostNeighborsOptimization;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define CONNECTEDCOMPONENTSATTRIBUTES_TMFS "b"

#endif
