// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtConnCompReduceFilter.h
// ************************************************************************* //

#ifndef AVT_ConnCompReduce_FILTER_H
#define AVT_ConnCompReduce_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <ConnCompReduceAttributes.h>

class vtkDataSet;
class vtkPolyData;
class vtkUnstructuredGrid;


// ****************************************************************************
//  Class: avtConnCompReduceFilter
//
//  Purpose:
//      A plugin operator for ConnCompReduce.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Oct 29 10:16:45 PDT 2002
//
//  Modifications:
//    Eric Brugger, Wed Jul 23 08:41:39 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtConnCompReduceFilter : public avtPluginDataTreeIterator
{
  public:
                         avtConnCompReduceFilter();
    virtual             ~avtConnCompReduceFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtConnCompReduceFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Reduce Connected Components"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    ConnCompReduceAttributes atts;
    bool                  haveIssuedWarning;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
    virtual void          PreExecute(void);

    vtkDataSet           *PolyDataExecute(vtkPolyData *);
    vtkDataSet           *UnstructuredGridExecute(vtkUnstructuredGrid *);
    void                  MakeComponentList(double, int, bool *);
    int                   DetermineConnectedComponents(vtkDataSet *, int *);
};


#endif
