// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISCONNCOMPREDUCEWINDOW_H
#define QVISCONNCOMPREDUCEWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class ConnCompReduceAttributes;
class QLabel;
class QLineEdit;

// ****************************************************************************
// Class: QvisConnCompReduceWindow
//
// Purpose:
//    Defines QvisConnCompReduceWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisConnCompReduceWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisConnCompReduceWindow(const int type,
                         ConnCompReduceAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisConnCompReduceWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void targetProcessText();
  private:
    QLineEdit *target;
    QLabel *targetLabel;

    ConnCompReduceAttributes *atts;
};



#endif
