// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisConnCompReduceWindow.h"

#include <ConnCompReduceAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisConnCompReduceWindow::QvisConnCompReduceWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisConnCompReduceWindow::QvisConnCompReduceWindow(const int type,
                         ConnCompReduceAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisConnCompReduceWindow::~QvisConnCompReduceWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisConnCompReduceWindow::~QvisConnCompReduceWindow()
{
}


// ****************************************************************************
// Method: QvisConnCompReduceWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisConnCompReduceWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    targetLabel = new QLabel(tr("Target Reduction "), central);
    mainLayout->addWidget(targetLabel,0,0);
    target = new QLineEdit(central);
    connect(target, SIGNAL(returnPressed()),
            this, SLOT(targetProcessText()));
    mainLayout->addWidget(target, 0,1);

}


// ****************************************************************************
// Method: QvisConnCompReduceWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisConnCompReduceWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case ConnCompReduceAttributes::ID_target:
            target->setText(DoubleToQString(atts->GetTarget()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisConnCompReduceWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisConnCompReduceWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);
    QString msg, temp;

    // Do target
    if(which_widget == ConnCompReduceAttributes::ID_target || doAll)
    {
        double val;
        if(LineEditGetDouble(target, val))
            atts->SetTarget(val);
        else
        {
            ResettingError(tr("Target Reduction "),
                DoubleToQString(atts->GetTarget()));
            atts->SetTarget(atts->GetTarget());
        }
    }

}


//
// Qt Slot functions
//


void
QvisConnCompReduceWindow::targetProcessText()
{
    GetCurrentValues(ConnCompReduceAttributes::ID_target);
    Apply();
}


