// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ConnCompReduceViewerEnginePluginInfo.C
// ****************************************************************************

#include <ConnCompReducePluginInfo.h>
#include <ConnCompReduceAttributes.h>

//
// Storage for static data elements.
//
ConnCompReduceAttributes *ConnCompReduceViewerEnginePluginInfo::clientAtts = NULL;
ConnCompReduceAttributes *ConnCompReduceViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ConnCompReduceViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
ConnCompReduceViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (ConnCompReduceViewerEnginePluginInfo::clientAtts == NULL)
    {
        ConnCompReduceViewerEnginePluginInfo::clientAtts  = new ConnCompReduceAttributes;
        ConnCompReduceViewerEnginePluginInfo::defaultAtts = new ConnCompReduceAttributes;
    }
}

// ****************************************************************************
//  Method: ConnCompReduceViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ConnCompReduceViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ConnCompReduceViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ConnCompReduceViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ConnCompReduceViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ConnCompReduceViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ConnCompReduceAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ConnCompReduceViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ConnCompReduceViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ConnCompReduceAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ConnCompReduceViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ConnCompReduceViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(ConnCompReduceAttributes*)atts = *defaultAtts;
    else
        *(ConnCompReduceAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: ConnCompReduceViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ConnCompReduceViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: ConnCompReduceViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ConnCompReduceViewerEnginePluginInfo::GetMenuName() const
{
    return "Reduce Connected Components";
}

