// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ConnCompReducePluginInfo.C
// ****************************************************************************

#include <ConnCompReducePluginInfo.h>
#include <ConnCompReduceAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(ConnCompReduce,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(ConnCompReduce,General)

// ****************************************************************************
//  Method: ConnCompReduceGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ConnCompReduceGeneralPluginInfo::GetName() const
{
    return "ConnCompReduce";
}

// ****************************************************************************
//  Method: ConnCompReduceGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ConnCompReduceGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ConnCompReduceGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ConnCompReduceGeneralPluginInfo::GetID() const
{
    return "ConnCompReduce_1.0";
}
// ****************************************************************************
//  Method: ConnCompReduceGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ConnCompReduceGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: ConnCompReduceGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ConnCompReduceGeneralPluginInfo::GetCategoryName() const
{
    return "Analysis";
}
