// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtConeFilter.h
// ************************************************************************* //

#ifndef AVT_Cone_FILTER_H
#define AVT_Cone_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <ConeAttributes.h>

class vtkClipPolyData;
class vtkCone;
class vtkDataSet;
class vtkImplicitBoolean;
class vtkPlane;
class vtkPolarTransformFilter;
class vtkTransformPolyDataFilter;
class vtkVisItCutter;


// ****************************************************************************
//  Class: avtConeFilter
//
//  Purpose:
//      A plugin operator for Cone.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed May 29 16:09:58 PST 2002
//
//  Modifications:
//    Kathleen Bonnell, Tue May 20 10:23:38 PDT 2003
//    Added method ModifyContract.
//
//    Kathleen Bonnell, Thu Apr 28 10:28:22 PDT 2005
//    Use vtkVisItCutter instead of vtkCutter, since it has logic to correctly
//    handle CellData.
//
//    David Camp, Thu May 23 12:52:53 PDT 2013
//    Moved the VTK pointers into a struct to allocate the destroy them for
//    changes to the code for threading. Also added functions to create and
//    destroy the VTK objects.
//
//    Eric Brugger, Wed Jul 23 08:37:40 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtConeFilter : public avtPluginDataTreeIterator
{
  public:
                                 avtConeFilter();
    virtual                     ~avtConeFilter();

    static avtFilter            *Create();

    virtual const char          *GetType(void)  { return "avtConeFilter"; };
    virtual const char          *GetDescription(void) 
                                             { return "Slicing by a cone"; };
    virtual void                 ReleaseData(void);

    virtual void                 SetAtts(const AttributeGroup*);
    virtual bool                 Equivalent(const AttributeGroup*);

  protected:
    ConeAttributes               atts;

    typedef struct AvtConeFilterVTKObjects
    {
        vtkCone                     *cone;
        vtkVisItCutter              *cutter;
        vtkImplicitBoolean          *allFunctions;
        vtkPlane                    *plane;
        vtkPolarTransformFilter     *polar;
        vtkTransformPolyDataFilter  *transform;
        vtkClipPolyData             *clipOffSides;
        vtkClipPolyData             *clipBottom;
        vtkPlane                    *planeToClipBottom;
        vtkClipPolyData             *clipByLength;
        vtkPlane                    *planeToClipByLength;
    } avtConeFilterVTKObjects;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
    virtual void                 UpdateDataObjectInfo(void);
    void                         SetUpClipping(avtConeFilterVTKObjects &obj);
    void                         SetUpCone(avtConeFilterVTKObjects &obj);
    void                         SetUpProjection(avtConeFilterVTKObjects &obj);
    avtContract_p                ModifyContract(avtContract_p);

    void                         CreateVTKObjects(avtConeFilterVTKObjects &obj);
    void                         DestroyVTKObjects(avtConeFilterVTKObjects &obj);
};

#endif

