// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ConeCommonPluginInfo.C
// ****************************************************************************

#include <ConePluginInfo.h>
#include <ConeAttributes.h>

// ****************************************************************************
//  Method: ConeCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ConeCommonPluginInfo::AllocAttributes()
{
    return new ConeAttributes;
}

// ****************************************************************************
//  Method: ConeCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Cone attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ConeCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ConeAttributes *) to) = *((ConeAttributes *) from);
}
