// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  ClipScriptingPluginInfo.C
// ************************************************************************* //
#include <PyClipAttributes.h>
#include <ClipPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Clip,Scripting)

// ****************************************************************************
// Method: ClipScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ClipScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyClipAttributes_StartUp((ClipAttributes *)subj, data);
}

// ****************************************************************************
// Method: ClipScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
ClipScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyClipAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ClipScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Clip plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ClipScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyClipAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ClipScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
ClipScriptingPluginInfo::GetLogString()
{
    std::string s(PyClipAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: ClipScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ClipScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyClipAttributes_SetDefaults((const ClipAttributes *)atts);
}
