// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ClipPluginInfo.h
// ****************************************************************************

#ifndef CLIP_PLUGIN_INFO_H
#define CLIP_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ClipAttributes;

// ****************************************************************************
//  Class: ClipPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Clip operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class ClipGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class ClipCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ClipGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class ClipGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ClipCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class ClipViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual ClipCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static ClipAttributes *defaultAtts;
    static ClipAttributes *clientAtts;
};

class ClipViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ClipViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class ClipEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ClipViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ClipScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ClipCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
