// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ClipCommonPluginInfo.C
// ****************************************************************************

#include <ClipPluginInfo.h>
#include <ClipAttributes.h>

// ****************************************************************************
//  Method: ClipCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ClipCommonPluginInfo::AllocAttributes()
{
    return new ClipAttributes;
}

// ****************************************************************************
//  Method: ClipCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Clip attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ClipCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ClipAttributes *) to) = *((ClipAttributes *) from);
}
