// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisCartographicProjectionWindow.h"

#include <CartographicProjectionAttributes.h>

#include <QComboBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisCartographicProjectionWindow::QvisCartographicProjectionWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: Jean Favre
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisCartographicProjectionWindow::QvisCartographicProjectionWindow(const int type,
                         CartographicProjectionAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisCartographicProjectionWindow::~QvisCartographicProjectionWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: Jean Favre
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisCartographicProjectionWindow::~QvisCartographicProjectionWindow()
{
}


// ****************************************************************************
// Method: QvisCartographicProjectionWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: Jean Favre
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisCartographicProjectionWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    projectionIDLabel = new QLabel(tr("Projection type"), central);
    mainLayout->addWidget(projectionIDLabel,0,0);
    int sp = 30+(int)mainLayout->verticalSpacing();
    mainLayout->setVerticalSpacing(sp);

    projectionIDCombo = new QComboBox(central);
    projectionIDCombo->addItem(tr("Aitoff"));
    projectionIDCombo->addItem(tr("Eckert IV"));
    projectionIDCombo->addItem(tr("Equidistant Conic"));
    projectionIDCombo->addItem(tr("Hammer"));
    projectionIDCombo->addItem(tr("Lambert Azimuthal Equal Area"));
    projectionIDCombo->addItem(tr("Lambert Conformal Conic"));
    projectionIDCombo->addItem(tr("Mercator"));
    projectionIDCombo->addItem(tr("Miller Cylindrical"));
    projectionIDCombo->addItem(tr("Mollweide"));
    projectionIDCombo->addItem(tr("Orthographic"));
    projectionIDCombo->addItem(tr("Winkel II"));

    connect(projectionIDCombo, SIGNAL(activated(int)),
            this, SLOT(projectionIDChanged(int)));
    mainLayout->addWidget(projectionIDCombo, 0,1);
    projectionIDCombo->setCurrentIndex(atts->GetProjectionID());

    centralMeridianLabel = new QLabel(tr("Central Meridian"), central);
    mainLayout->addWidget(centralMeridianLabel,1,0);
    centralMeridian = new QLineEdit(central);
    connect(centralMeridian, SIGNAL(returnPressed()),
            this, SLOT(centralMeridianProcessText()));
    mainLayout->addWidget(centralMeridian, 1,1);
}


// ****************************************************************************
// Method: QvisCartographicProjectionWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: Jean Favre
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisCartographicProjectionWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case CartographicProjectionAttributes::ID_projectionID:
            projectionIDCombo->blockSignals(true);
            projectionIDCombo->setCurrentIndex(atts->GetProjectionID());
            projectionIDCombo->blockSignals(false);
            break;
          case CartographicProjectionAttributes::ID_centralMeridian:
            centralMeridian->setText(DoubleToQString(atts->GetCentralMeridian()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisCartographicProjectionWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: Jean Favre
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisCartographicProjectionWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do centralMeridian
    if(which_widget == CartographicProjectionAttributes::ID_centralMeridian || doAll)
    {
        double val;
        if(LineEditGetDouble(centralMeridian, val))
            atts->SetCentralMeridian(val);
        else
        {
            ResettingError(tr("Central Meridian"),
                DoubleToQString(atts->GetCentralMeridian()));
            atts->SetCentralMeridian(atts->GetCentralMeridian());
        }
    }

}


//
// Qt Slot functions
//


void
QvisCartographicProjectionWindow::projectionIDChanged(int val)
{
    if(val != atts->GetProjectionID())
    {
        atts->SetProjectionID(CartographicProjectionAttributes::ProjectionID(val));
        SetUpdate(false);
        Apply();
    }
}

void
QvisCartographicProjectionWindow::centralMeridianProcessText()
{
    GetCurrentValues(CartographicProjectionAttributes::ID_centralMeridian);
    Apply();
}
