// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  CartographicProjectionScriptingPluginInfo.C
// ************************************************************************* //
#include <PyCartographicProjectionAttributes.h>
#include <CartographicProjectionPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(CartographicProjection,Scripting)

// ****************************************************************************
// Method: CartographicProjectionScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
CartographicProjectionScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyCartographicProjectionAttributes_StartUp((CartographicProjectionAttributes *)subj, data);
}

// ****************************************************************************
// Method: CartographicProjectionScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
CartographicProjectionScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyCartographicProjectionAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: CartographicProjectionScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is CartographicProjection plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
CartographicProjectionScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyCartographicProjectionAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: CartographicProjectionScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
CartographicProjectionScriptingPluginInfo::GetLogString()
{
    std::string s(PyCartographicProjectionAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: CartographicProjectionScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
CartographicProjectionScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyCartographicProjectionAttributes_SetDefaults((const CartographicProjectionAttributes *)atts);
}
