// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CartographicProjectionPluginInfo.h
// ****************************************************************************

#ifndef CARTOGRAPHICPROJECTION_PLUGIN_INFO_H
#define CARTOGRAPHICPROJECTION_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class CartographicProjectionAttributes;

// ****************************************************************************
//  Class: CartographicProjectionPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an CartographicProjection operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class CartographicProjectionGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class CartographicProjectionCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual CartographicProjectionGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class CartographicProjectionGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual CartographicProjectionCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class CartographicProjectionViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual CartographicProjectionCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static CartographicProjectionAttributes *defaultAtts;
    static CartographicProjectionAttributes *clientAtts;
};

class CartographicProjectionViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual CartographicProjectionViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class CartographicProjectionEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual CartographicProjectionViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class CartographicProjectionScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual CartographicProjectionCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
