// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CartographicProjectionGUIPluginInfo.C
// ****************************************************************************

#include <CartographicProjectionPluginInfo.h>
#include <CartographicProjectionAttributes.h>
#include <QApplication>
#include <QvisCartographicProjectionWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(CartographicProjection,GUI)

// ****************************************************************************
//  Method: CartographicProjectionGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
CartographicProjectionGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Cartographic Projection"));
}


// ****************************************************************************
//  Method: CartographicProjectionGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
CartographicProjectionGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisCartographicProjectionWindow(type, (CartographicProjectionAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: CartographicProjectionGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <CartographicProjection.xpm>
const char **
CartographicProjectionGUIPluginInfo::XPMIconData() const
{
    return CartographicProjection_xpm;
}

