// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtBoxFilter.h
// ************************************************************************* //

#ifndef AVT_Box_FILTER_H
#define AVT_Box_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <BoxAttributes.h>

class vtkDataSet;
class vtkRectilinearGrid;
class vtkUnstructuredGrid;


// ****************************************************************************
//  Class: avtBoxFilter
//
//  Purpose:
//      A plugin operator for Box.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Nov 12 16:57:31 PST 2001
//
//  Modifications:
//
//    Mark C. Miller, Tue Sep 28 19:57:42 PDT 2004
//    Added selection id and ModifyContract implementation
//
//    Hank Childs, Sun Apr 24 11:11:46 PDT 2005
//    Add special support for rectilinear grids. ['6155]
//
//    Kathleen Bonnell, Mon Mar 23 18:26:59 PDT 2009
//    Made this derive again from avtPluginDataTreeIterator instead of
//    avtSIMODataTreeIterator.
// 
//    Eric Brugger, Tue Jul 22 17:07:12 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtBoxFilter : public avtPluginDataTreeIterator
{
  public:
                         avtBoxFilter();
    virtual             ~avtBoxFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtBoxFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Finding cells within a box"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    BoxAttributes   atts;
    int             selID;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
    vtkRectilinearGrid    *RectilinearExecute(vtkRectilinearGrid *);
    vtkUnstructuredGrid   *GeneralExecute(vtkDataSet *);
    virtual void           UpdateDataObjectInfo(void);
    virtual avtContract_p  ModifyContract(avtContract_p);
    vtkRectilinearGrid    *CurveExecute(vtkRectilinearGrid *);

};


#endif
