// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: BoxCommonPluginInfo.C
// ****************************************************************************

#include <BoxPluginInfo.h>
#include <BoxAttributes.h>

// ****************************************************************************
//  Method: BoxCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
BoxCommonPluginInfo::AllocAttributes()
{
    return new BoxAttributes;
}

// ****************************************************************************
//  Method: BoxCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Box attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
BoxCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((BoxAttributes *) to) = *((BoxAttributes *) from);
}
