// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef BOXATTRIBUTES_H
#define BOXATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: BoxAttributes
//
// Purpose:
//    This class contains attributes for the box operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class BoxAttributes : public AttributeSubject
{
public:
    enum Amount
    {
        Some,
        All
    };

    // These constructors are for objects of this class
    BoxAttributes();
    BoxAttributes(const BoxAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    BoxAttributes(private_tmfs_t tmfs);
    BoxAttributes(const BoxAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~BoxAttributes();

    virtual BoxAttributes& operator = (const BoxAttributes &obj);
    virtual bool operator == (const BoxAttributes &obj) const;
    virtual bool operator != (const BoxAttributes &obj) const;
private:
    void Init();
    void Copy(const BoxAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetAmount(Amount amount_);
    void SetMinx(double minx_);
    void SetMaxx(double maxx_);
    void SetMiny(double miny_);
    void SetMaxy(double maxy_);
    void SetMinz(double minz_);
    void SetMaxz(double maxz_);
    void SetInverse(bool inverse_);

    // Property getting methods
    Amount GetAmount() const;
    double GetMinx() const;
    double GetMaxx() const;
    double GetMiny() const;
    double GetMaxy() const;
    double GetMinz() const;
    double GetMaxz() const;
    bool   GetInverse() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string Amount_ToString(Amount);
    static bool Amount_FromString(const std::string &, Amount &);
protected:
    static std::string Amount_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_amount = 0,
        ID_minx,
        ID_maxx,
        ID_miny,
        ID_maxy,
        ID_minz,
        ID_maxz,
        ID_inverse,
        ID__LAST
    };

private:
    int    amount;
    double minx;
    double maxx;
    double miny;
    double maxy;
    double minz;
    double maxz;
    bool   inverse;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define BOXATTRIBUTES_TMFS "iddddddb"

#endif
