// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: BoundaryOpPluginInfo.h
// ****************************************************************************

#ifndef BOUNDARYOP_PLUGIN_INFO_H
#define BOUNDARYOP_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class BoundaryOpAttributes;

// ****************************************************************************
//  Class: BoundaryOpPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an BoundaryOp operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class BoundaryOpGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class BoundaryOpCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual BoundaryOpGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class BoundaryOpGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual BoundaryOpCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class BoundaryOpViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual BoundaryOpCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static BoundaryOpAttributes *defaultAtts;
    static BoundaryOpAttributes *clientAtts;
};

class BoundaryOpViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual BoundaryOpViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class BoundaryOpEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual BoundaryOpViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class BoundaryOpScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual BoundaryOpCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
