// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: BoundaryOpPluginInfo.C
// ****************************************************************************

#include <BoundaryOpPluginInfo.h>
#include <BoundaryOpAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(BoundaryOp,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(BoundaryOp,General)

// ****************************************************************************
//  Method: BoundaryOpGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
BoundaryOpGeneralPluginInfo::GetName() const
{
    return "BoundaryOp";
}

// ****************************************************************************
//  Method: BoundaryOpGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
BoundaryOpGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: BoundaryOpGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
BoundaryOpGeneralPluginInfo::GetID() const
{
    return "BoundaryOp_1.0";
}
// ****************************************************************************
//  Method: BoundaryOpGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
BoundaryOpGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: BoundaryOpGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
BoundaryOpGeneralPluginInfo::GetCategoryName() const
{
    return "Slicing";
}
