// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: BoundaryOpAttributes
//
// Purpose:
//    Attributes for Boundary Operator
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class BoundaryOpAttributes extends AttributeSubject implements Plugin
{
    private static int BoundaryOpAttributes_numAdditionalAtts = 1;

    public BoundaryOpAttributes()
    {
        super(BoundaryOpAttributes_numAdditionalAtts);

        smoothingLevel = 0;
    }

    public BoundaryOpAttributes(int nMoreFields)
    {
        super(BoundaryOpAttributes_numAdditionalAtts + nMoreFields);

        smoothingLevel = 0;
    }

    public BoundaryOpAttributes(BoundaryOpAttributes obj)
    {
        super(obj);

        smoothingLevel = obj.smoothingLevel;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return BoundaryOpAttributes_numAdditionalAtts;
    }

    public boolean equals(BoundaryOpAttributes obj)
    {
        // Create the return value
        return ((smoothingLevel == obj.smoothingLevel));
    }

    public String GetName() { return "BoundaryOp"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetSmoothingLevel(int smoothingLevel_)
    {
        smoothingLevel = smoothingLevel_;
        Select(0);
    }

    // Property getting methods
    public int GetSmoothingLevel() { return smoothingLevel; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(smoothingLevel);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        SetSmoothingLevel(buf.ReadInt());
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intToString("smoothingLevel", smoothingLevel, indent) + "\n";
        return str;
    }


    // Attributes
    private int smoothingLevel;
}

