// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <BoundaryOpAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: BoundaryOpAttributes::BoundaryOpAttributes
//
// Purpose:
//   Init utility for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void BoundaryOpAttributes::Init()
{
    smoothingLevel = 0;

    BoundaryOpAttributes::SelectAll();
}

// ****************************************************************************
// Method: BoundaryOpAttributes::BoundaryOpAttributes
//
// Purpose:
//   Copy utility for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void BoundaryOpAttributes::Copy(const BoundaryOpAttributes &obj)
{
    smoothingLevel = obj.smoothingLevel;

    BoundaryOpAttributes::SelectAll();
}

// Type map format string
const char *BoundaryOpAttributes::TypeMapFormatString = BOUNDARYOPATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t BoundaryOpAttributes::TmfsStruct = {BOUNDARYOPATTRIBUTES_TMFS};


// ****************************************************************************
// Method: BoundaryOpAttributes::BoundaryOpAttributes
//
// Purpose:
//   Default constructor for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoundaryOpAttributes::BoundaryOpAttributes() :
    AttributeSubject(BoundaryOpAttributes::TypeMapFormatString)
{
    BoundaryOpAttributes::Init();
}

// ****************************************************************************
// Method: BoundaryOpAttributes::BoundaryOpAttributes
//
// Purpose:
//   Constructor for the derived classes of BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoundaryOpAttributes::BoundaryOpAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    BoundaryOpAttributes::Init();
}

// ****************************************************************************
// Method: BoundaryOpAttributes::BoundaryOpAttributes
//
// Purpose:
//   Copy constructor for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoundaryOpAttributes::BoundaryOpAttributes(const BoundaryOpAttributes &obj) :
    AttributeSubject(BoundaryOpAttributes::TypeMapFormatString)
{
    BoundaryOpAttributes::Copy(obj);
}

// ****************************************************************************
// Method: BoundaryOpAttributes::BoundaryOpAttributes
//
// Purpose:
//   Copy constructor for derived classes of the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoundaryOpAttributes::BoundaryOpAttributes(const BoundaryOpAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    BoundaryOpAttributes::Copy(obj);
}

// ****************************************************************************
// Method: BoundaryOpAttributes::~BoundaryOpAttributes
//
// Purpose:
//   Destructor for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoundaryOpAttributes::~BoundaryOpAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: BoundaryOpAttributes::operator =
//
// Purpose:
//   Assignment operator for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoundaryOpAttributes&
BoundaryOpAttributes::operator = (const BoundaryOpAttributes &obj)
{
    if (this == &obj) return *this;

    BoundaryOpAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: BoundaryOpAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoundaryOpAttributes::operator == (const BoundaryOpAttributes &obj) const
{
    // Create the return value
    return ((smoothingLevel == obj.smoothingLevel));
}

// ****************************************************************************
// Method: BoundaryOpAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoundaryOpAttributes::operator != (const BoundaryOpAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: BoundaryOpAttributes::TypeName
//
// Purpose:
//   Type name method for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
BoundaryOpAttributes::TypeName() const
{
    return "BoundaryOpAttributes";
}

// ****************************************************************************
// Method: BoundaryOpAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoundaryOpAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const BoundaryOpAttributes *tmp = (const BoundaryOpAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: BoundaryOpAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
BoundaryOpAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new BoundaryOpAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: BoundaryOpAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the BoundaryOpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
BoundaryOpAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new BoundaryOpAttributes(*this);
    else
        retval = new BoundaryOpAttributes;

    return retval;
}

// ****************************************************************************
// Method: BoundaryOpAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
BoundaryOpAttributes::SelectAll()
{
    Select(ID_smoothingLevel, (void *)&smoothingLevel);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: BoundaryOpAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoundaryOpAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    BoundaryOpAttributes defaultObject;
    bool addToParent = false;
    // Create a node for BoundaryOpAttributes.
    DataNode *node = new DataNode("BoundaryOpAttributes");

    if(completeSave || !FieldsEqual(ID_smoothingLevel, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("smoothingLevel", smoothingLevel));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: BoundaryOpAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
BoundaryOpAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("BoundaryOpAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("smoothingLevel")) != 0)
        SetSmoothingLevel(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
BoundaryOpAttributes::SetSmoothingLevel(int smoothingLevel_)
{
    smoothingLevel = smoothingLevel_;
    Select(ID_smoothingLevel, (void *)&smoothingLevel);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
BoundaryOpAttributes::GetSmoothingLevel() const
{
    return smoothingLevel;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: BoundaryOpAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
BoundaryOpAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_smoothingLevel: return "smoothingLevel";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: BoundaryOpAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
BoundaryOpAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_smoothingLevel: return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: BoundaryOpAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
BoundaryOpAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_smoothingLevel: return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: BoundaryOpAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoundaryOpAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const BoundaryOpAttributes &obj = *((const BoundaryOpAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_smoothingLevel:
        {  // new scope
        retval = (smoothingLevel == obj.smoothingLevel);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

