// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtAxisAlignedSlice4DFilter.h
// ************************************************************************* //

#ifndef AVT_AxisAlignedSlice4D_FILTER_H
#define AVT_AxisAlignedSlice4D_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <AxisAlignedSlice4DAttributes.h>


// ****************************************************************************
//  Class: avtAxisAlignedSlice4DFilter
//
//  Purpose:
//      A plugin operator for AxisAlignedSlice4D.
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Thu Jan 7 16:44:23 PST 2016
//
// ****************************************************************************

class avtAxisAlignedSlice4DFilter : public avtPluginDataTreeIterator
{
  public:
                         avtAxisAlignedSlice4DFilter();
    virtual             ~avtAxisAlignedSlice4DFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtAxisAlignedSlice4DFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Axis Aligned Slice 4D"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

    virtual avtContract_p   ModifyContract(avtContract_p);
    virtual void            UpdateDataObjectInfo(void);
  protected:
    AxisAlignedSlice4DAttributes   atts;
    std::string        outVarName;

    virtual void                     PreExecute(void);
    virtual avtDataRepresentation   *ExecuteData(avtDataRepresentation *in_dr);
    virtual void                     PostExecute(void);

  private:
    double                           spatialExtents[6];
    double                           range[2];

    int                              fixedAxis[2];
    int                              varyingAxis[2];
    int                              sliceIndex[2];
};

#endif
