// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisAxisAlignedSlice4DWindow.h"

#include <AxisAlignedSlice4DAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisAxisAlignedSlice4DWindow::QvisAxisAlignedSlice4DWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisAxisAlignedSlice4DWindow::QvisAxisAlignedSlice4DWindow(const int type,
                         AxisAlignedSlice4DAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisAxisAlignedSlice4DWindow::~QvisAxisAlignedSlice4DWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisAxisAlignedSlice4DWindow::~QvisAxisAlignedSlice4DWindow()
{
}


// ****************************************************************************
// Method: QvisAxisAlignedSlice4DWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisAxisAlignedSlice4DWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    ILabel = new QLabel(tr("I"), central);
    mainLayout->addWidget(ILabel,0,0);
    I = new QLineEdit(central);
    connect(I, SIGNAL(returnPressed()),
            this, SLOT(IProcessText()));
    mainLayout->addWidget(I, 0,1);

    JLabel = new QLabel(tr("J"), central);
    mainLayout->addWidget(JLabel,1,0);
    J = new QLineEdit(central);
    connect(J, SIGNAL(returnPressed()),
            this, SLOT(JProcessText()));
    mainLayout->addWidget(J, 1,1);

    KLabel = new QLabel(tr("K"), central);
    mainLayout->addWidget(KLabel,2,0);
    K = new QLineEdit(central);
    connect(K, SIGNAL(returnPressed()),
            this, SLOT(KProcessText()));
    mainLayout->addWidget(K, 2,1);

    LLabel = new QLabel(tr("L"), central);
    mainLayout->addWidget(LLabel,3,0);
    L = new QLineEdit(central);
    connect(L, SIGNAL(returnPressed()),
            this, SLOT(LProcessText()));
    mainLayout->addWidget(L, 3,1);

}


// ****************************************************************************
// Method: QvisAxisAlignedSlice4DWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisAxisAlignedSlice4DWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case AxisAlignedSlice4DAttributes::ID_I:
            I->setText(IntsToQString(atts->GetI()));
            break;
          case AxisAlignedSlice4DAttributes::ID_J:
            J->setText(IntsToQString(atts->GetJ()));
            break;
          case AxisAlignedSlice4DAttributes::ID_K:
            K->setText(IntsToQString(atts->GetK()));
            break;
          case AxisAlignedSlice4DAttributes::ID_L:
            L->setText(IntsToQString(atts->GetL()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisAxisAlignedSlice4DWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisAxisAlignedSlice4DWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do I
    if(which_widget == AxisAlignedSlice4DAttributes::ID_I || doAll)
    {
        intVector val;
        if(I->text().isEmpty() || LineEditGetInts(I, val))
            atts->SetI(val);
        else
        {
            ResettingError(tr("I"),
                IntsToQString(atts->GetI()));
            atts->SetI(atts->GetI());
        }
    }

    // Do J
    if(which_widget == AxisAlignedSlice4DAttributes::ID_J || doAll)
    {
        intVector val;
        if(J->text().isEmpty() || LineEditGetInts(J, val))
            atts->SetJ(val);
        else
        {
            ResettingError(tr("J"),
                IntsToQString(atts->GetJ()));
            atts->SetJ(atts->GetJ());
        }
    }

    // Do K
    if(which_widget == AxisAlignedSlice4DAttributes::ID_K || doAll)
    {
        intVector val;
        if(K->text().isEmpty() || LineEditGetInts(K, val))
            atts->SetK(val);
        else
        {
            ResettingError(tr("K"),
                IntsToQString(atts->GetK()));
            atts->SetK(atts->GetK());
        }
    }

    // Do L
    if(which_widget == AxisAlignedSlice4DAttributes::ID_L || doAll)
    {
        intVector val;
        if(L->text().isEmpty() || LineEditGetInts(L, val))
            atts->SetL(val);
        else
        {
            ResettingError(tr("L"),
                IntsToQString(atts->GetL()));
            atts->SetL(atts->GetL());
        }
    }

}


//
// Qt Slot functions
//


void
QvisAxisAlignedSlice4DWindow::IProcessText()
{
    GetCurrentValues(AxisAlignedSlice4DAttributes::ID_I);
    Apply();
}


void
QvisAxisAlignedSlice4DWindow::JProcessText()
{
    GetCurrentValues(AxisAlignedSlice4DAttributes::ID_J);
    Apply();
}


void
QvisAxisAlignedSlice4DWindow::KProcessText()
{
    GetCurrentValues(AxisAlignedSlice4DAttributes::ID_K);
    Apply();
}


void
QvisAxisAlignedSlice4DWindow::LProcessText()
{
    GetCurrentValues(AxisAlignedSlice4DAttributes::ID_L);
    Apply();
}


