// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  AxisAlignedSlice4DScriptingPluginInfo.C
// ************************************************************************* //
#include <PyAxisAlignedSlice4DAttributes.h>
#include <AxisAlignedSlice4DPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(AxisAlignedSlice4D,Scripting)

// ****************************************************************************
// Method: AxisAlignedSlice4DScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
AxisAlignedSlice4DScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyAxisAlignedSlice4DAttributes_StartUp((AxisAlignedSlice4DAttributes *)subj, data);
}

// ****************************************************************************
// Method: AxisAlignedSlice4DScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
AxisAlignedSlice4DScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyAxisAlignedSlice4DAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: AxisAlignedSlice4DScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is AxisAlignedSlice4D plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AxisAlignedSlice4DScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyAxisAlignedSlice4DAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: AxisAlignedSlice4DScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
AxisAlignedSlice4DScriptingPluginInfo::GetLogString()
{
    std::string s(PyAxisAlignedSlice4DAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: AxisAlignedSlice4DScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
AxisAlignedSlice4DScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyAxisAlignedSlice4DAttributes_SetDefaults((const AxisAlignedSlice4DAttributes *)atts);
}
