// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: AxisAlignedSlice4DPluginInfo.C
// ****************************************************************************

#include <AxisAlignedSlice4DPluginInfo.h>
#include <AxisAlignedSlice4DAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(AxisAlignedSlice4D,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(AxisAlignedSlice4D,General)

// ****************************************************************************
//  Method: AxisAlignedSlice4DGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
AxisAlignedSlice4DGeneralPluginInfo::GetName() const
{
    return "AxisAlignedSlice4D";
}

// ****************************************************************************
//  Method: AxisAlignedSlice4DGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
AxisAlignedSlice4DGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: AxisAlignedSlice4DGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
AxisAlignedSlice4DGeneralPluginInfo::GetID() const
{
    return "AxisAlignedSlice4D_1.0";
}
// ****************************************************************************
//  Method: AxisAlignedSlice4DGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
AxisAlignedSlice4DGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: AxisAlignedSlice4DGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
AxisAlignedSlice4DGeneralPluginInfo::GetCategoryName() const
{
    return "Slicing";
}
