// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: AxisAlignedSlice4DCommonPluginInfo.C
// ****************************************************************************

#include <AxisAlignedSlice4DPluginInfo.h>
#include <AxisAlignedSlice4DAttributes.h>

#include <Expression.h>
#include <ExpressionList.h>
#include <avtDatabaseMetaData.h>
#include <avtArrayMetaData.h>

// ****************************************************************************
//  Method: AxisAlignedSlice4DCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
AxisAlignedSlice4DCommonPluginInfo::AllocAttributes()
{
    return new AxisAlignedSlice4DAttributes;
}

// ****************************************************************************
//  Method: AxisAlignedSlice4DCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a AxisAlignedSlice4D attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
AxisAlignedSlice4DCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((AxisAlignedSlice4DAttributes *) to) = *((AxisAlignedSlice4DAttributes *) from);
}
ExpressionList *
AxisAlignedSlice4DCommonPluginInfo::GetCreatedExpressions(const avtDatabaseMetaData *md) const
{
    char name[1024];
    char defn[1024];
    ExpressionList *el = new ExpressionList;

    for (int i = 0 ; i < md->GetNumArrays() ; i++)
    {
        avtArrayMetaData const &amd = md->GetArrays(i);

        if (amd.hideFromGUI || !amd.validVariable)
            continue;

        const char *array = amd.name.c_str();
        const char *mesh = amd.meshName.c_str();

        Expression e;
        sprintf(name, "operators/AxisAlignedSlice4D/%s", array);
        e.SetName(name);
        e.SetType(Expression::ScalarMeshVar);
        e.SetFromOperator(true);
        e.SetOperatorName("AxisAlignedSlice4D");
        sprintf(defn, "cell_constant(<%s>, 0)", mesh);
        e.SetDefinition(defn);
        el->AddExpressions(e);
    }

    const ExpressionList &oldEL = md->GetExprList();
    for (int i = 0 ; i < oldEL.GetNumExpressions() ; i++)
    {
        const Expression &e = oldEL.GetExpressions(i);
        if (e.GetType() == Expression::ArrayMeshVar)
        {
            {
                if (e.GetFromOperator() || e.GetAutoExpression())
                    continue; // weird ordering behavior otherwise
                Expression e2;
                sprintf(name, "operators/AxisAlignedSlice4D/%s", e.GetName().c_str());
                e2.SetName(name);
                e2.SetType(Expression::ScalarMeshVar);
                e2.SetFromOperator(true);
                e2.SetOperatorName("AxisAlignedSlice4D");
                sprintf(defn, "cell_constant(<%s>, 0.)", e.GetName().c_str());
                e2.SetDefinition(defn);
                el->AddExpressions(e2);
            }
        }
    }

    return el;
}

