// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef AXISALIGNEDSLICE4DATTRIBUTES_H
#define AXISALIGNEDSLICE4DATTRIBUTES_H
#include <AttributeSubject.h>


// ****************************************************************************
// Class: AxisAlignedSlice4DAttributes
//
// Purpose:
//    Attributes for AxisAlignedSlice4D
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class AxisAlignedSlice4DAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    AxisAlignedSlice4DAttributes();
    AxisAlignedSlice4DAttributes(const AxisAlignedSlice4DAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    AxisAlignedSlice4DAttributes(private_tmfs_t tmfs);
    AxisAlignedSlice4DAttributes(const AxisAlignedSlice4DAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~AxisAlignedSlice4DAttributes();

    virtual AxisAlignedSlice4DAttributes& operator = (const AxisAlignedSlice4DAttributes &obj);
    virtual bool operator == (const AxisAlignedSlice4DAttributes &obj) const;
    virtual bool operator != (const AxisAlignedSlice4DAttributes &obj) const;
private:
    void Init();
    void Copy(const AxisAlignedSlice4DAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectI();
    void SelectJ();
    void SelectK();
    void SelectL();

    // Property setting methods
    void SetI(const intVector &I_);
    void SetJ(const intVector &J_);
    void SetK(const intVector &K_);
    void SetL(const intVector &L_);

    // Property getting methods
    const intVector &GetI() const;
          intVector &GetI();
    const intVector &GetJ() const;
          intVector &GetJ();
    const intVector &GetK() const;
          intVector &GetK();
    const intVector &GetL() const;
          intVector &GetL();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_I = 0,
        ID_J,
        ID_K,
        ID_L,
        ID__LAST
    };

private:
    intVector I;
    intVector J;
    intVector K;
    intVector L;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define AXISALIGNEDSLICE4DATTRIBUTES_TMFS "i*i*i*i*"

#endif
