// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtAMRStitchCellFilter.h
// ************************************************************************* //

#ifndef AVT_AMRStitchCell_FILTER_H
#define AVT_AMRStitchCell_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <AMRStitchCellAttributes.h>

#include <vtkType.h>

#include <string>
#include <vector>

class vtkDataSet;
class vtkRectilinearGrid;
class avtStructuredDomainNesting;


// ****************************************************************************
//  Class: avtAMRStitchCellFilter
//
//  Purpose:
//      A plugin operator for AMRStitchCell.
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Thu Jul 8 15:14:01 PST 2010
//
//  Modifications:
//    Eric Brugger, Tue Jul 22 17:01:30 PDT 2014
//    Modified the class to work with avtDataRepresentation
//
// ****************************************************************************

class avtAMRStitchCellFilter :  public virtual avtSIMODataTreeIterator,
                                public virtual avtPluginFilter
{
  public:
                          avtAMRStitchCellFilter();
    virtual              ~avtAMRStitchCellFilter();

    static avtFilter     *Create();

    virtual const char   *GetType(void)  { return "avtAMRStitchCellFilter"; };
    virtual const char   *GetDescription(void)
                              { return "Creating dual grid and stitch cells for AMR data"; };

    virtual void          SetAtts(const AttributeGroup*);
    virtual bool          Equivalent(const AttributeGroup*);

  protected:
    AMRStitchCellAttributes
                          atts;

    virtual void          PreExecute(void);
    virtual avtContract_p ModifyContract(avtContract_p);
    virtual avtDataTree_p ExecuteDataTree(avtDataRepresentation *);
    virtual void          UpdateDataObjectInfo(void);
    vtkDataSet           *CreateStitchCells(vtkRectilinearGrid*, int, int, int[3],
                              int[3], int[3], int[3], const std::vector<int>&,
                              const vtkIdType*);
    vtkDataSet           *CreateDualGrid(vtkRectilinearGrid*, int, int, int[3],
                              int [3], int [3], const vtkIdType*);
#if 0
    vtkDataArray         *ContractDual(vtkDataArray *coords);
#endif

  private:
    int                   topologicalDimension;
    int                   spatialDimension;
    avtStructuredDomainNesting
                         *domainNesting;
    double                domainOrigin[3];
    std::vector< std::vector<int> >
                          logicalDomainBoundingBox;
    std::vector<std::vector<double> >
                          cellSize;
};

#endif
