// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: AMRStitchCellPluginInfo.h
// ****************************************************************************

#ifndef AMRSTITCHCELL_PLUGIN_INFO_H
#define AMRSTITCHCELL_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class AMRStitchCellAttributes;

// ****************************************************************************
//  Class: AMRStitchCellPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an AMRStitchCell operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class AMRStitchCellGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class AMRStitchCellCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual AMRStitchCellGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class AMRStitchCellGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual AMRStitchCellCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class AMRStitchCellViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual AMRStitchCellCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static AMRStitchCellAttributes *defaultAtts;
    static AMRStitchCellAttributes *clientAtts;
};

class AMRStitchCellViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual AMRStitchCellViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class AMRStitchCellEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual AMRStitchCellViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class AMRStitchCellScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual AMRStitchCellCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
